package easik.ui.tree.popup;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import easik.Easik;
import easik.sketch.constraint.Constraint;


/**
 * Hide constraint menu action for the information tree.
 * 
 * @author Kevin Green 2006
 * @since 2006-07-13 Kevin Green
 * @version 2006-07-13 Kevin Green
 */
public class HideConstraint extends AbstractAction {	
	
	/**
	 *	Set up the edit attribute menu option.
	 */
	public HideConstraint() {
		super("Hide constraint");
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Makes the selected contraint invisib;e.");		
	}
	
	/**
	 * Makes the selected constraint invisible
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		//If there is nothing seleceted then just do nothing
		if(Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().isSelectionEmpty())
		{
			return;
		}
	
		//Get currently selected object
		DefaultMutableTreeNode curSelectedNode = (DefaultMutableTreeNode) 
					Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().getSelectionPath().getLastPathComponent();
		Object curSelected = curSelectedNode.getUserObject();
		
		//Selection is a constraint
		if(curSelected instanceof Constraint){
			((Constraint)curSelected).setVisible(false);		
		}
		//Selection is not a constraint
		else{ 
			JOptionPane.showMessageDialog(Easik.getInstance().getFrame(),
					"You don't have a constraint selected. \nPlease select a constraint and try again.",
					"No Constraint Selected", JOptionPane.ERROR_MESSAGE);
		}
	}
}